/**
 * @file tuya_hal_rtc.c
 * @brief RTC操作接口
 * 
 * @copyright Copyright(C),2018-2020, 涂鸦科技 www.tuya.com
 * 
 */

#include "rtc_api.h"
#include "wait_api.h"
#include "tuya_hal_rtc.h"

/***********************************************************
*************************micro define***********************
***********************************************************/

/***********************************************************
*************************variable define********************
***********************************************************/

/***********************************************************
*************************function define********************
***********************************************************/
/**
 * @brief RTC 初始化
 * 
 */
void tuya_hal_rtc_init(void)
{
    rtc_init();
    rtc_write(0);
}


/**
 * @brief 设置 RTC 时间
 * 
 * @param[in]       write_time  写入的 RTC 时间值,单位s
 */
void tuya_hal_rtc_set_time(const time_t time) 
{
    rtc_write(time);
}


/**
 * @brief 获取 RTC 时间
 * 
 * @return  获取的 RTC 时间值
 */
time_t tuya_hal_rtc_get_time(void)
{
    time_t time= rtc_read();
    
    return time;
}


