/**
 * @file tuya_hal_watchdog.c
 * @brief 看门狗接口
 * 
 * @copyright Copyright (c) {2018-2020} 涂鸦科技 www.tuya.com
 * 
 */

#include "tuya_hal_watchdog.h"
#include "tuya_os_adapter_errcode.h"

/***********************************************************
*************************micro define***********************
***********************************************************/

/***********************************************************
*************************variable define********************
***********************************************************/

/***********************************************************
*************************function define********************
***********************************************************/
/**
 * @brief 用于初始化并运行watchdog
 * 
 * @param[in] timeval watch dog检测时间间隔：如果timeval大于看门狗的
 * 最大可设置时间，则使用平台可设置时间的最大值，并且返回该最大值
 * @return int [out] 实际设置的看门狗时间
 */
unsigned int tuya_hal_watchdog_init_start(const unsigned int timeval)
{
	int tval = timeval;
	if(timeval > 60)
		tval = 60;
		
    watchdog_init(tval * 1000);
    watchdog_start();

    return tval;
}

/**
 * @brief 用于刷新watch dog
 * 
 */
void tuya_hal_watchdog_refresh(void)
{
    watchdog_refresh();
}

/**
 * @brief 用于停止watch dog
 * 
 */
void tuya_hal_watchdog_stop(void)
{
    watchdog_stop();
}