/**
 * @file tuya_hal_memory.c
 * @brief 内存操作接口
 * 
 * @copyright Copyright(C),2018-2020, 涂鸦科技 www.tuya.com
 * 
 */
 
#include <FreeRTOS.h>
#include "tuya_hal_memory.h"


/***********************************************************
*************************micro define***********************
***********************************************************/

/***********************************************************
*************************variable define********************
***********************************************************/


/***********************************************************
*************************function define********************
***********************************************************/
/**
 * @brief tuya_hal_system_malloc用于分配内存
 * 
 * @param[in]       size        需要分配的内存大小
 * @return  分配得到的内存指针
 */
void *tuya_hal_system_malloc(const size_t size)
{
    if(size == 0) {
        return NULL;
    }
    
    return pvPortMalloc(size);
}

/**
 * @brief tuya_hal_system_free用于释放内存
 * 
 * @param[in]       ptr         需要释放的内存指针
 */
void tuya_hal_system_free(void* ptr)
{
    if(ptr == NULL) {
        return;
    }
    
    vPortFree(ptr);
}

