/**
 * @file tuya_hal_output.c
 * @brief 日志操作接口
 * 
 * @copyright Copyright(C),2018-2020, 涂鸦科技 www.tuya.com
 * 
 */
#define _UNI_OUTPUT_GLOBAL
#include "rtl8710b.h"
#include "tuya_hal_output.h"
#include "tuya_os_adapter_errcode.h"

/***********************************************************
*************************micro define***********************
***********************************************************/
/* 终端输出函数 */
#define OutputPrint DiagPrintf

/***********************************************************
*************************variable define********************
***********************************************************/

/***********************************************************
*************************function define********************
***********************************************************/
/**
 * @brief tuya_hal_output_log用于输出log信息
 * 
 * @param[in] str log buffer指针
 */
void tuya_hal_output_log(const char *str)
{
    if(str == NULL) {
        return;
    }
	
    OutputPrint("%s",str);
}

/**
 * @brief 用于关闭原厂sdk默认的log口
 * 
 */
int tuya_hal_log_close(void)
{
    sys_log_uart_off();
    
    return OPRT_OS_ADAPTER_OK;
}

/**
 * @brief 用于恢复原厂sdk默认的log口
 * 
 */
int tuya_hal_log_open(void)
{
    sys_log_uart_on();
    
    return OPRT_OS_ADAPTER_OK;
}

